IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_SCA_ValidoTicketEvento]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_SCA_ValidoTicketEvento] 
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_ValidoTicketEvento]		@pTag					VARCHAR(MAX),
														@pId_Acceso				SMALLINT,
														@pFecha					DATETIME, 
														@Flag_TicketHabilitado	INT OUTPUT
AS
BEGIN
DECLARE @Flag_Valida_Links		TINYINT
DECLARE @Existe_QR				INT
DECLARE @Flag_QR_Vigente		TINYINT
DECLARE @Flag_QR_YaUtilizado	TINYINT
DECLARE @Evento_QR_Formato		VARCHAR(40)
DECLARE @Id_Lista_Precio		SMALLINT
DECLARE @Id_Acceso				SMALLINT
DECLARE @Ticket_Nro				INT

/*
Valores Posibles de @Flag_TicketHabilitado:

	1: Es valido 
	0: Ticket Invalido
   -1: Ticket ya esta utilizado
   -2: Ticket Puerta Incorrecta
*/


SET @Evento_QR_Formato = dbo.CF_xParam('Evento_QR_Formato')

IF(@Evento_QR_Formato NOT IN ('14'))
BEGIN
	SET @Flag_TicketHabilitado = 0
END

IF(@Evento_QR_Formato IN ('14'))
BEGIN
	IF(LEN(@pTag) = 14)
	BEGIN
		IF(dbo.Is_Numeric(@pTag) = 1)
		BEGIN
			SET @Id_Lista_Precio	= SUBSTRING(@pTag, 1, 4)
			SET @Id_Acceso			= SUBSTRING(@pTag, 5, 3)
			SET @Ticket_Nro			= SUBSTRING(@pTag, 8, 7)

			SET @Flag_TicketHabilitado = 1
		END
		ELSE
		BEGIN
			SET @Flag_TicketHabilitado = 0
		END
	END
	ELSE
	BEGIN
		SET @Flag_TicketHabilitado = 0
	END
END

RETURN ISNULL(@Flag_TicketHabilitado, 0)
END
